<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!--Area Report-->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!--Title displayed in browser Title Bar-->
                <title lang="en">Výpis plochy</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!--Report Title-->
                                <h2 lang="en">Výpis plochy</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!--Project Data-->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <table class="margin" cellpadding="2" width="50%">
                                    <thead>
                                        <tr>
                                            <xsl:if test="//@linearUnits = 'Imperial'">
                                                <th class="underline" lang="en">Název plochy</th>
                                                <th class="underline" lang="en">Plocha (st2)</th>
                                                <th class="underline" lang="en">Plocha (akr)</th>
                                                <th class="underline" lang="en">Obvod (st)</th>
                                            </xsl:if>
                                            <xsl:if test="//@linearUnits =   'Metric'">
                                                <th class="underline" lang="en">Název plochy</th>
                                                <th class="underline" lang="en">Plocha (m2)</th>
                                                <th class="underline" lang="en">Plocha (ha)</th>
                                                <th class="underline" lang="en">Obvod (m)</th>
                                            </xsl:if>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!--Horizontal Alignment Data-->
                                        <xsl:for-each select="HorizontalAlignment[@area > 0]">
                                            <tr>
                                                <td class="sidepad" align="left"><xsl:value-of select="@name"/></td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:areaFormat(number(@area))"/>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:if test="//@linearUnits = 'Imperial'">
                                                        <xsl:value-of select="cif:acreFormat(number(@area) div 43560)"/>
                                                    </xsl:if>
                                                    <xsl:if test="//@linearUnits = 'Metric'">
                                                        <xsl:value-of select="cif:acreFormat(number(@area) div 10000)"/>
                                                    </xsl:if>
                                                </td>
                                                <td class="sidepad" align="right">
                                                    <xsl:value-of select="cif:distanceFormat(number(@perimeter))"/>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jeden Civil uzavřený prvek směrové geometrie (nebo s možností uzavření v počátečním a koncovém bodě).
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
